@extends('layouts.app')

@section('title', 'My Appointments')

@section('content')
<div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
    <div class="flex flex-col sm:flex-row justify-between items-start sm:items-center mb-6 gap-4">
        <h1 class="text-3xl font-bold text-gray-800">My Appointments</h1>
        <div class="flex gap-2">
            <a href="{{ route('pharmacist.appointments.create') }}" class="bg-blue-600 hover:bg-blue-700 text-white px-4 py-2 rounded">
                <i class="fas fa-plus mr-2"></i>Create New Appointment
            </a>
            <a href="{{ route('pharmacist.dashboard') }}" class="bg-gray-600 hover:bg-gray-700 text-white px-4 py-2 rounded">
                <i class="fas fa-arrow-left mr-2"></i>Back to Dashboard
            </a>
        </div>
    </div>

    <div class="bg-white rounded-lg shadow overflow-hidden">
        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50">
                    <tr>
                        <th class="px-3 sm:px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Patient</th>
                        <th class="px-3 sm:px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase hidden md:table-cell">Doctor</th>
                        <th class="px-3 sm:px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase hidden lg:table-cell">Branch</th>
                        <th class="px-3 sm:px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Date</th>
                        <th class="px-3 sm:px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase hidden sm:table-cell">Type</th>
                        <th class="px-3 sm:px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Status</th>
                        <th class="px-3 sm:px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Actions</th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-200">
                    @foreach($appointments as $appointment)
                    <tr>
                        <td class="px-3 sm:px-6 py-4 whitespace-nowrap">
                            <span class="text-sm sm:text-base">{{ $appointment->patient->full_name }}</span>
                        </td>
                        <td class="px-3 sm:px-6 py-4 whitespace-nowrap hidden md:table-cell">
                            <span class="text-sm">{{ $appointment->doctor ? $appointment->doctor->full_name : 'N/A' }}</span>
                        </td>
                        <td class="px-3 sm:px-6 py-4 whitespace-nowrap hidden lg:table-cell">
                            <span class="text-sm">{{ $appointment->branch->name }}</span>
                        </td>
                        <td class="px-3 sm:px-6 py-4 whitespace-nowrap">
                            <span class="text-xs sm:text-sm">{{ $appointment->appointment_date->format('M d, Y H:i') }}</span>
                        </td>
                        <td class="px-3 sm:px-6 py-4 whitespace-nowrap hidden sm:table-cell">
                            <span class="text-xs sm:text-sm">{{ $appointment->consultation_type }}</span>
                        </td>
                        <td class="px-3 sm:px-6 py-4 whitespace-nowrap">
                            <span class="px-2 py-1 text-xs rounded-full bg-{{ $appointment->status === 'completed' ? 'green' : ($appointment->status === 'pending' ? 'yellow' : 'blue') }}-100 text-{{ $appointment->status === 'completed' ? 'green' : ($appointment->status === 'pending' ? 'yellow' : 'blue') }}-800">
                                {{ ucfirst($appointment->status) }}
                            </span>
                        </td>
                        <td class="px-3 sm:px-6 py-4 whitespace-nowrap text-xs sm:text-sm font-medium">
                            <div class="flex flex-col sm:flex-row gap-1 sm:gap-2">
                                @if($appointment->google_meet_link)
                                    <a href="{{ $appointment->google_meet_link }}" target="_blank" class="text-green-600 hover:text-green-900 whitespace-nowrap">
                                        <i class="fas fa-video"></i> <span class="hidden sm:inline">Google Meet</span><span class="sm:hidden">Meet</span>
                                    </a>
                                @elseif($appointment->video_call_room_id)
                                    <a href="{{ route('pharmacist.video-call', $appointment->id) }}" class="text-blue-600 hover:text-blue-900 whitespace-nowrap">
                                        <i class="fas fa-video"></i> <span class="hidden sm:inline">Join Video Call</span><span class="sm:hidden">Video</span>
                                    </a>
                                @endif
                            </div>
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
</div>
@endsection

